package net.guerlab.smart.pay.service.mapper;

import net.guerlab.smart.pay.service.entity.PayOrder;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.Mapper;

/**
 * 支付订单Mapper
 *
 * @author guer
 */
public interface PayOrderMapper extends Mapper<PayOrder> {

    /**
     * 标记异常
     *
     * @param payOrderId
     *         支付订单ID
     * @param exceptionReason
     *         异常ID
     */
    void markException(@Param("payOrderId") Long payOrderId, @Param("exceptionReason") String exceptionReason);

    /**
     * 移除标记异常
     *
     * @param payOrderId
     *         支付订单ID
     */
    void removeExceptionMark(@Param("payOrderId") Long payOrderId);
}
