package net.guerlab.smart.pay.service.mapper;

import net.guerlab.smart.pay.service.entity.PayLog;
import org.apache.ibatis.annotations.Param;
import tk.mybatis.mapper.common.Mapper;

/**
 * 支付记录Mapper
 *
 * @author guer
 */
public interface PayLogMapper extends Mapper<PayLog> {

    /**
     * 标记异常
     *
     * @param payLogId
     *         支付记录ID
     * @param exceptionReason
     *         异常ID
     */
    void markException(@Param("payLogId") Long payLogId, @Param("exceptionReason") String exceptionReason);

    /**
     * 移除标记异常
     *
     * @param payLogId
     *         支付记录ID
     */
    void removeExceptionMark(@Param("payLogId") Long payLogId);
}
