package net.guerlab.smart.pay.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.pay.core.domain.AlipayConfigDTO;
import net.guerlab.smart.platform.commons.entity.BaseEntity;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * 支付宝支付配置
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Table(name = "pay_alipay_config")
public class AlipayConfig extends BaseEntity implements DefaultConvertDTO<AlipayConfigDTO> {

    /**
     * 应用ID
     */
    @Id
    private String appId;

    /**
     * 应用名称
     */
    @Column(name = "appName", nullable = false)
    private String appName;

    /**
     * 用户私钥
     */
    @Column(name = "privateKey", nullable = false)
    private String privateKey;

    /**
     * 支付宝公钥
     */
    @Column(name = "alipayPublicKey", nullable = false)
    private String alipayPublicKey;

    /**
     * 启用标志
     */
    @Column(name = "enable", nullable = false)
    private Boolean enable;

    /**
     * 启用测试环境标志
     */
    @Column(name = "enableDevEnv", nullable = false)
    private Boolean enableDevEnv;
}
