/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.service.service.impl;

import net.guerlab.smart.pay.core.exception.WxPayConfigAppIdInvalidException;
import net.guerlab.smart.pay.core.exception.WxPayConfigAppIdRepeatException;
import net.guerlab.smart.pay.core.exception.WxPayConfigAppNameInvalidException;
import net.guerlab.smart.pay.core.exception.WxPayConfigAppNameLengthErrorException;
import net.guerlab.smart.pay.core.exception.WxPayConfigKeyContentBase64InvalidException;
import net.guerlab.smart.pay.core.exception.WxPayConfigMchIdInvalidException;
import net.guerlab.smart.pay.core.exception.WxPayConfigMchKeyInvalidException;
import net.guerlab.smart.pay.service.entity.WxPayConfig;
import net.guerlab.smart.pay.service.mapper.WxPayConfigMapper;
import net.guerlab.smart.pay.service.service.WxPayConfigService;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class WxPayConfigServiceImpl
extends BaseServiceImpl<WxPayConfig, String, WxPayConfigMapper>
implements WxPayConfigService {
    protected void insertBefore(WxPayConfig entity) {
        String appId = StringUtils.trimToNull((String)entity.getAppId());
        String appName = StringUtils.trimToNull((String)entity.getAppName());
        String mchId = StringUtils.trimToNull((String)entity.getMchId());
        String mchKey = StringUtils.trimToNull((String)entity.getMchKey());
        String keyContentBase64 = StringUtils.trimToNull((String)entity.getKeyContentBase64());
        if (appId == null) {
            throw new WxPayConfigAppIdInvalidException();
        }
        if (this.selectById(appId) != null) {
            throw new WxPayConfigAppIdRepeatException();
        }
        if (appName == null) {
            throw new WxPayConfigAppNameInvalidException();
        }
        if (appName.length() > 255) {
            throw new WxPayConfigAppNameLengthErrorException();
        }
        if (mchId == null) {
            throw new WxPayConfigMchIdInvalidException();
        }
        if (mchKey == null) {
            throw new WxPayConfigMchKeyInvalidException();
        }
        if (keyContentBase64 == null) {
            throw new WxPayConfigKeyContentBase64InvalidException();
        }
        entity.setAppId(appId);
        entity.setMchId(mchId);
        entity.setMchKey(mchKey);
        entity.setSubAppId(StringUtils.trimToNull((String)entity.getSubAppId()));
        entity.setSubMchId(StringUtils.trimToNull((String)entity.getSubMchId()));
        entity.setKeyContentBase64(keyContentBase64);
        if (entity.getEnable() == null) {
            entity.setEnable(true);
        }
    }

    protected void updateBefore(WxPayConfig entity) {
        String appName = StringUtils.trimToNull((String)entity.getAppName());
        if (appName != null && appName.length() > 255) {
            throw new WxPayConfigAppNameLengthErrorException();
        }
        entity.setAppName(appName);
        entity.setMchId(StringUtils.trimToNull((String)entity.getMchId()));
        entity.setMchKey(StringUtils.trimToNull((String)entity.getMchKey()));
        entity.setSubAppId(StringUtils.trimToNull((String)entity.getSubAppId()));
        entity.setSubMchId(StringUtils.trimToNull((String)entity.getSubMchId()));
        entity.setKeyContentBase64(StringUtils.trimToNull((String)entity.getKeyContentBase64()));
    }
}

