/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.service.service.impl;

import java.time.LocalDateTime;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.pay.core.domain.PayLogExtends;
import net.guerlab.smart.pay.core.enums.PayStatus;
import net.guerlab.smart.pay.core.exception.BusinessGroupInvalidException;
import net.guerlab.smart.pay.core.exception.BusinessIdInvalidException;
import net.guerlab.smart.pay.core.exception.PayChannelInvalidException;
import net.guerlab.smart.pay.core.exception.PayOrderIdInvalidException;
import net.guerlab.smart.pay.core.exception.PayOrderInvalidException;
import net.guerlab.smart.pay.core.exception.PayStatusErrorException;
import net.guerlab.smart.pay.core.searchparams.PayOrderSearchParams;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.service.entity.PayOrder;
import net.guerlab.smart.pay.service.mapper.PayLogMapper;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.pay.service.service.PayOrderService;
import net.guerlab.smart.pay.stream.binders.PayOrderStatusChangeSenderChannel;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.smart.platform.stream.utils.MessageUtils;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.annotation.EnableBinding;
import org.springframework.messaging.MessageChannel;
import org.springframework.stereotype.Service;

@Service
@EnableBinding(value={PayOrderStatusChangeSenderChannel.class})
public class PayLogServiceImpl
extends BaseServiceImpl<PayLog, Long, PayLogMapper>
implements PayLogService {
    private PayOrderService payOrderService;
    private PayOrderStatusChangeSenderChannel statusChangeSender;

    @Override
    public void payed(PayLog entity) {
        PayOrder payOrder = this.findPayOrder(entity.getPayOrderId());
        LocalDateTime now = LocalDateTime.now();
        boolean needSendNotify = false;
        if (payOrder.getPayStatus() == PayStatus.WAIT_PAY) {
            payOrder.setPayStatus(PayStatus.PAYED);
            payOrder.setPayedTime(now);
            this.payOrderService.updateSelectiveById((Object)payOrder);
            needSendNotify = true;
        }
        entity.setPayStatus(PayStatus.PAYED);
        entity.setPayedTime(now);
        this.updateSelectiveById((Object)entity);
        if (needSendNotify) {
            MessageUtils.send((MessageChannel)this.statusChangeSender.output(), (Object)((Object)payOrder));
        }
    }

    @Override
    public PayLog create(Long payOrderId, String payChannel, PayLogExtends extend) {
        PayOrder payOrder = this.findPayOrder(payOrderId);
        return this.create(payOrder, payChannel, extend);
    }

    @Override
    public PayLog create(String businessGroup, String businessId, String payChannel, PayLogExtends extend) {
        PayOrder payOrder = this.findPayOrder(businessGroup, businessId);
        return this.create(payOrder, payChannel, extend);
    }

    private PayLog create(PayOrder payOrder, String payChannel, PayLogExtends extend) {
        String channel = StringUtils.trimToNull((String)payChannel);
        if (channel == null) {
            throw new PayChannelInvalidException();
        }
        if (payOrder.getPayStatus() != PayStatus.WAIT_PAY) {
            throw new PayStatusErrorException();
        }
        PayLog payLog = new PayLog();
        payLog.setPayLogId(this.sequence.nextId());
        payLog.setPayOrderId(payOrder.getPayOrderId());
        payLog.setOrderTitle(payOrder.getOrderTitle());
        payLog.setBusinessGroup(payOrder.getBusinessGroup());
        payLog.setBusinessId(payOrder.getBusinessId());
        payLog.setPayChannel(payChannel);
        payLog.setAmount(payOrder.getAmount());
        payLog.setPayStatus(PayStatus.WAIT_PAY);
        payLog.setCreateTime(LocalDateTime.now());
        payLog.setPayTimeoutTime(payOrder.getPayTimeoutTime());
        payLog.setPayedTime(null);
        payLog.setPayCancelTime(null);
        payLog.setExtend(extend == null ? new PayLogExtends() : extend);
        ((PayLogMapper)this.mapper).insertSelective((Object)payLog);
        return payLog;
    }

    private PayOrder findPayOrder(Long payOrderId) {
        if (!NumberHelper.greaterOrEqualZero((Number)payOrderId)) {
            throw new PayOrderIdInvalidException();
        }
        return (PayOrder)((Object)this.payOrderService.selectByIdOptional(payOrderId).orElseThrow(PayOrderInvalidException::new));
    }

    private PayOrder findPayOrder(String businessGroup, String businessId) {
        String tempBusinessGroup = StringUtils.trimToNull((String)businessGroup);
        String tempBusinessId = StringUtils.trimToNull((String)businessId);
        if (tempBusinessGroup == null) {
            throw new BusinessGroupInvalidException();
        }
        if (tempBusinessId == null) {
            throw new BusinessIdInvalidException();
        }
        PayOrderSearchParams searchParams = new PayOrderSearchParams();
        searchParams.setBusinessGroup(tempBusinessGroup);
        searchParams.setBusinessId(businessId);
        return (PayOrder)((Object)this.payOrderService.selectOneOptional((AbstractSearchParams)searchParams).orElseThrow(PayOrderInvalidException::new));
    }

    @Autowired
    public void setPayOrderService(PayOrderService payOrderService) {
        this.payOrderService = payOrderService;
    }

    @Autowired
    public void setStatusChangeSender(PayOrderStatusChangeSenderChannel statusChangeSender) {
        this.statusChangeSender = statusChangeSender;
    }
}

