/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.service.wx;

import com.github.binarywang.wxpay.bean.request.WxPayUnifiedOrderRequest;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.impl.WxPayServiceApacheHttpImpl;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.commons.random.RandomUtil;
import net.guerlab.smart.pay.service.wx.WxPayProperties;

public class WxPayService
extends WxPayServiceApacheHttpImpl {
    private final WxPayProperties properties;
    private final ThreadLocal<String> appId = new ThreadLocal();

    WxPayService(WxPayProperties properties) {
        this.properties = properties;
        this.config = new WxPayConfig();
        this.config.setMchId(properties.getMchId());
        this.config.setMchKey(properties.getMchKey());
        this.config.setSubAppId(properties.getSubAppId());
        this.config.setSubMchId(properties.getSubMchId());
        this.config.setKeyPath(properties.getKeyPath());
    }

    public WxPayConfig getConfig() {
        WxPayConfig parent = super.getConfig();
        WxPayConfig config = new WxPayConfig();
        config.setAppId(this.appId.get());
        config.setMchId(parent.getMchId());
        config.setMchKey(parent.getMchKey());
        config.setSubAppId(parent.getSubAppId());
        config.setSubMchId(parent.getSubMchId());
        config.setKeyPath(parent.getKeyPath());
        return config;
    }

    public <T> T createOrder(WxPayUnifiedOrderRequest request) {
        this.appId.set(request.getAppid());
        request.setMchId(this.properties.getMchId());
        request.setSubAppId(this.properties.getSubAppId());
        request.setSubMchId(this.properties.getSubMchId());
        request.setNonceStr(RandomUtil.nextString((int)6));
        request.setNotifyUrl(this.properties.getNotifyUrl() + request.getNotifyUrl());
        try {
            Object object = super.createOrder(request);
            return (T)object;
        }
        catch (WxPayException e) {
            throw new ApplicationException(e.getErrCodeDes());
        }
        finally {
            this.appId.remove();
        }
    }

    public WxPayProperties getProperties() {
        return this.properties;
    }

    public ThreadLocal<String> getAppId() {
        return this.appId;
    }
}

