package net.guerlab.smart.pay.service.wx;

import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 微信公众号自动配置
 *
 * @author guer
 */
@Configuration
@EnableConfigurationProperties(WxPayProperties.class)
public class WxPayAutoConfiguration {

    /**
     * 微信支付服务
     *
     * @param configs
     *         微信支付配置信息
     * @return 微信支付服务
     */
    @Bean
    public WxPayService wxPayService(WxPayProperties configs) {
        return new WxPayService(configs);
    }

}
