package net.guerlab.smart.pay.service.service;

import net.guerlab.smart.pay.core.domain.PayLogExtends;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.platform.server.service.BaseFindService;

/**
 * 支付记录服务
 *
 * @author guer
 */
public interface PayLogService extends BaseFindService<PayLog, Long> {

    /**
     * 支付完成
     *
     * @param payLog
     *         支付记录
     */
    void payed(PayLog payLog);

    /**
     * 通过支付订单ID、支付渠道创建支付记录
     *
     * @param payOrderId
     *         支付订单ID
     * @param payChannel
     *         支付渠道
     * @param extend
     *         扩展信息
     * @return 支付记录
     */
    PayLog create(Long payOrderId, String payChannel, PayLogExtends extend);

    /**
     * 通过业务分组、业务ID、支付渠道创建支付记录
     *
     * @param businessGroup
     *         业务分组
     * @param businessId
     *         业务ID
     * @param payChannel
     *         支付渠道
     * @param extend
     *         扩展信息
     * @return 支付记录
     */
    PayLog create(String businessGroup, String businessId, String payChannel, PayLogExtends extend);

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<PayLog> getEntityClass() {
        return PayLog.class;
    }
}
