package net.guerlab.smart.pay.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.pay.core.domain.PayOrderDTO;
import net.guerlab.smart.pay.core.enums.PayStatus;
import net.guerlab.smart.platform.commons.entity.BaseEntity;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 支付订单
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Table(name = "pay_order")
public class PayOrder extends BaseEntity implements DefaultConvertDTO<PayOrderDTO> {

    /**
     * 支付订单ID
     */
    @Id
    private Long payOrderId;

    /**
     * 订单标题
     */
    @Column(name = "orderTitle", nullable = false, updatable = false)
    private String orderTitle;

    /**
     * 业务分组
     */
    @Column(name = "businessGroup", nullable = false, updatable = false)
    private String businessGroup;

    /**
     * 业务ID
     */
    @Column(name = "businessId", nullable = false, updatable = false)
    private String businessId;

    /**
     * 金额
     */
    @Column(name = "amount", nullable = false, updatable = false)
    private BigDecimal amount;

    /**
     * 支付状态
     */
    @Column(name = "payStatus", nullable = false)
    private PayStatus payStatus;

    /**
     * 创建时间
     */
    @Column(name = "createTime", nullable = false, updatable = false)
    private LocalDateTime createTime;

    /**
     * 支付超时时间
     */
    @Column(name = "payTimeoutTime", nullable = false, updatable = false)
    private LocalDateTime payTimeoutTime;

    /**
     * 支付完成时间
     */
    private LocalDateTime payedTime;

    /**
     * 支付取消时间
     */
    @Column(name = "payCancelTime", insertable = false)
    private LocalDateTime payCancelTime;

}
