package net.guerlab.smart.pay.internal.controller.inside;

import io.swagger.annotations.ApiParam;
import net.guerlab.smart.pay.core.domain.PayLogDTO;
import net.guerlab.smart.pay.core.exception.PayLogInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayLogSearchParams;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

/**
 * 支付记录
 *
 * @author guer
 */
@RestController("/inside/payLog")
@RequestMapping("/inside/payLog")
public class PayLogController {

    private PayLogService service;

    @GetMapping("/{id}")
    public PayLogDTO findOne(@ApiParam(value = "id", required = true) @PathVariable Long id) {
        return service.selectByIdOptional(id).orElseThrow(PayLogInvalidException::new).toDTO();
    }

    @PostMapping
    public ListObject<PayLogDTO> findList(@RequestBody PayLogSearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @PostMapping("/all")
    public Collection<PayLogDTO> findAll(@RequestBody PayLogSearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    @Autowired
    public void setService(PayLogService service) {
        this.service = service;
    }

}
