package net.guerlab.smart.pay.internal.controller.inside;

import io.swagger.annotations.ApiParam;
import net.guerlab.smart.pay.core.domain.PayOrderDTO;
import net.guerlab.smart.pay.core.exception.PayOrderInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayOrderSearchParams;
import net.guerlab.smart.pay.service.entity.PayOrder;
import net.guerlab.smart.pay.service.service.PayOrderService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

/**
 * 支付订单
 *
 * @author guer
 */
@RestController("/inside/payOrder")
@RequestMapping("/inside/payOrder")
public class PayOrderController {

    private PayOrderService service;

    @GetMapping("/{id}")
    public PayOrderDTO findOne(@ApiParam(value = "id", required = true) @PathVariable Long id) {
        return service.selectByIdOptional(id).orElseThrow(PayOrderInvalidException::new).toDTO();
    }

    @PostMapping
    public ListObject<PayOrderDTO> findList(@RequestBody PayOrderSearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @PostMapping("/all")
    public Collection<PayOrderDTO> findAll(@RequestBody PayOrderSearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    @PutMapping
    public PayOrderDTO add(@RequestBody PayOrderDTO dto) {
        PayOrder order = new PayOrder();
        BeanUtils.copyProperties(dto, order);
        service.insertSelective(order);
        return order.toDTO();
    }

    @Autowired
    public void setService(PayOrderService service) {
        this.service = service;
    }

}
