/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.internal.controller.inside;

import io.swagger.annotations.ApiParam;
import java.util.Collection;
import net.guerlab.smart.pay.core.domain.PayOrderDTO;
import net.guerlab.smart.pay.core.exception.PayOrderInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayOrderSearchParams;
import net.guerlab.smart.pay.service.entity.PayOrder;
import net.guerlab.smart.pay.service.service.PayOrderService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController(value="/inside/payOrder")
@RequestMapping(value={"/inside/payOrder"})
public class PayOrderController {
    private PayOrderService service;

    @GetMapping(value={"/{id}"})
    public PayOrderDTO findOne(@ApiParam(value="id", required=true) @PathVariable Long id) {
        return (PayOrderDTO)((PayOrder)this.service.selectByIdOptional((Object)id).orElseThrow(PayOrderInvalidException::new)).toDTO();
    }

    @PostMapping
    public ListObject<PayOrderDTO> findList(@RequestBody PayOrderSearchParams searchParams) {
        return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
    }

    @PostMapping(value={"/all"})
    public Collection<PayOrderDTO> findAll(@RequestBody PayOrderSearchParams searchParams) {
        return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
    }

    @PutMapping
    public PayOrderDTO add(@RequestBody PayOrderDTO dto) {
        PayOrder order = new PayOrder();
        BeanUtils.copyProperties((Object)dto, (Object)order);
        this.service.insertSelective((Object)order);
        return (PayOrderDTO)order.toDTO();
    }

    @Autowired
    public void setService(PayOrderService service) {
        this.service = service;
    }
}

