package net.guerlab.smart.pay.internal.controller.inside;

import io.swagger.annotations.ApiParam;
import net.guerlab.smart.pay.core.domain.PayLogNotifyDTO;
import net.guerlab.smart.pay.core.exception.PayLogNotifyInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayLogNotifySearchParams;
import net.guerlab.smart.pay.service.service.PayLogNotifyService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.Collection;

/**
 * 支付记录通知服务
 *
 * @author guer
 */
@RestController("/inside/payLogNotify")
@RequestMapping("/inside/payLogNotify")
public class PayLogNotifyController {

    private PayLogNotifyService service;

    @GetMapping("/{id}")
    public PayLogNotifyDTO findOne(@ApiParam(value = "id", required = true) @PathVariable Long id) {
        return service.selectByIdOptional(id).orElseThrow(PayLogNotifyInvalidException::new).toDTO();
    }

    @PostMapping
    public ListObject<PayLogNotifyDTO> findList(@RequestBody PayLogNotifySearchParams searchParams) {
        return BeanConvertUtils.toListObject(service.selectPage(searchParams));
    }

    @PostMapping("/all")
    public Collection<PayLogNotifyDTO> findAll(@RequestBody PayLogNotifySearchParams searchParams) {
        return BeanConvertUtils.toList(service.selectAll(searchParams));
    }

    @Autowired
    public void setService(PayLogNotifyService service) {
        this.service = service;
    }

}
