package net.guerlab.smart.pay.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;

/**
 * 支付宝支付配置搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("微信支付配置搜索参数")
public class AlipayConfigSearchParams extends AbstractSearchParams {

    /**
     * 应用ID
     */
    @ApiModelProperty("应用ID")
    private String appId;

    /**
     * 应用名称关键字
     */
    @ApiModelProperty("应用名称关键字")
    @SearchModel(SearchModelType.LIKE)
    @Column(name = "appName")
    private String appNameLike;

    /**
     * 启用标志
     */
    @ApiModelProperty("启用标志")
    private Boolean enable;

    /**
     * 启用测试环境标志
     */
    @ApiModelProperty("启用测试环境标志")
    private Boolean enableDevEnv;
}
