package net.guerlab.smart.pay.core.searchparams;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.OrderByType;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;
import java.time.LocalDateTime;

/**
 * 通知原始记录搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("通知原始记录搜索参数")
public class NotifyOriginalLogSearchParams extends AbstractSearchParams {

    /**
     * 通知原始记录ID
     */
    @ApiModelProperty("通知原始记录ID")
    private Long notifyOriginalLogId;

    /**
     * 支付渠道
     */
    @ApiModelProperty("支付渠道")
    private String payChannel;

    /**
     * 创建时间开始范围
     */
    @ApiModelProperty("创建时间开始范围")
    @Column(name = "createTime")
    @SearchModel(SearchModelType.GREATER_THAN_OR_EQUAL_TO)
    private LocalDateTime createTimeStartWith;

    /**
     * 创建时间结束范围
     */
    @ApiModelProperty("创建时间结束范围")
    @Column(name = "createTime")
    @SearchModel(SearchModelType.LESS_THAN_OR_EQUAL_TO)
    private LocalDateTime createTimeEndWith;

    /**
     * 通知原始记录ID排序方式
     */
    @ApiModelProperty(hidden = true)
    @Column(name = "notifyOriginalLogId")
    @JsonIgnore
    private OrderByType notifyOriginalLogIdOrderByType = OrderByType.DESC;
}
