package net.guerlab.smart.pay.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 通知原始记录
 *
 * @author guer
 */
@Data
@ApiModel("通知原始记录")
public class NotifyOriginalLogDTO {

    /**
     * 通知原始记录ID
     */
    @ApiModelProperty("通知原始记录ID")
    private Long notifyOriginalLogId;

    /**
     * 支付渠道
     */
    @ApiModelProperty("支付渠道")
    private String payChannel;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 内容
     */
    @ApiModelProperty("内容")
    private String content;

    /**
     * 响应
     */
    @ApiModelProperty("响应")
    private String result;
}
