package net.guerlab.smart.pay.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 支付宝支付配置
 *
 * @author guer
 */
@Data
@ApiModel("微信支付配置")
public class AlipayConfigDTO {

    /**
     * 应用ID
     */
    @ApiModelProperty("应用ID")
    private String appId;

    /**
     * 应用名称
     */
    @ApiModelProperty("应用名称")
    private String appName;

    /**
     * 用户私钥
     */
    @ApiModelProperty("用户私钥")
    private String privateKey;

    /**
     * 支付宝公钥
     */
    @ApiModelProperty("支付宝公钥")
    private String alipayPublicKey;

    /**
     * 启用标志
     */
    @ApiModelProperty("启用标志")
    private Boolean enable;

    /**
     * 启用测试环境标志
     */
    @ApiModelProperty("启用测试环境标志")
    private Boolean enableDevEnv;
}
