package net.guerlab.smart.pay.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;

/**
 * 微信支付配置搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("微信支付配置搜索参数")
public class WxPayConfigSearchParams extends AbstractSearchParams {

    /**
     * 应用ID
     */
    @ApiModelProperty("应用ID")
    private String appId;

    /**
     * 应用名称关键字
     */
    @ApiModelProperty("应用名称关键字")
    @SearchModel(SearchModelType.LIKE)
    @Column(name = "appName")
    private String appNameLike;

    /**
     * 微信支付商户号
     */
    @ApiModelProperty("微信支付商户号")
    private String mchId;

    /**
     * 服务商模式下的子商户公众账号ID
     */
    @ApiModelProperty("服务商模式下的子商户公众账号ID")
    private String subAppId;

    /**
     * 服务商模式下的子商户号
     */
    @ApiModelProperty("服务商模式下的子商户号")
    private String subMchId;

    /**
     * 启用标志
     */
    @ApiModelProperty("启用标志")
    private Boolean enable;
}
