package net.guerlab.smart.pay.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 微信支付配置
 *
 * @author guer
 */
@Data
@ApiModel("微信支付配置")
public class WxPayConfigDTO {

    /**
     * 应用ID
     */
    @ApiModelProperty("应用ID")
    private String appId;

    /**
     * 应用名称
     */
    @ApiModelProperty("应用名称")
    private String appName;

    /**
     * 微信支付商户号
     */
    @ApiModelProperty("微信支付商户号")
    private String mchId;

    /**
     * 微信支付商户密钥
     */
    @ApiModelProperty("微信支付商户密钥")
    private String mchKey;

    /**
     * 服务商模式下的子商户公众账号ID
     */
    @ApiModelProperty("服务商模式下的子商户公众账号ID")
    private String subAppId;

    /**
     * 服务商模式下的子商户号
     */
    @ApiModelProperty("服务商模式下的子商户号")
    private String subMchId;

    /**
     * p12证书文件内容
     */
    @ApiModelProperty("p12证书文件内容")
    private String keyContentBase64;

    /**
     * 启用标志
     */
    @ApiModelProperty("启用标志")
    private Boolean enable;
}
