package net.guerlab.smart.pay.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.smart.pay.core.enums.PayStatus;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;
import java.time.LocalDateTime;
import java.util.Collection;

/**
 * 支付订单搜索参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("支付订单搜索参数")
public class PayOrderSearchParams extends AbstractSearchParams {

    /**
     * 支付订单ID
     */
    @ApiModelProperty("支付订单ID")
    private Long payOrderId;

    /**
     * 支付订单ID列表
     */
    @ApiModelProperty("支付订单ID列表")
    @SearchModel(SearchModelType.IN)
    @Column(name = "payOrderId")
    private Collection<Long> payOrderIds;

    /**
     * 订单标题关键字
     */
    @ApiModelProperty("订单标题关键字")
    @SearchModel(SearchModelType.LIKE)
    @Column(name = "orderTitle")
    private String orderTitleLike;

    /**
     * 业务分组
     */
    @ApiModelProperty("业务分组")
    private String businessGroup;

    /**
     * 业务ID
     */
    @ApiModelProperty("业务ID")
    private String businessId;

    /**
     * 支付状态
     */
    @ApiModelProperty("支付状态")
    private PayStatus payStatus;

    /**
     * 创建时间开始范围
     */
    @ApiModelProperty("创建时间开始范围")
    @Column(name = "createTime")
    @SearchModel(SearchModelType.GREATER_THAN_OR_EQUAL_TO)
    private LocalDateTime createTimeStartWith;

    /**
     * 创建时间结束范围
     */
    @ApiModelProperty("创建时间结束范围")
    @Column(name = "createTime")
    @SearchModel(SearchModelType.LESS_THAN_OR_EQUAL_TO)
    private LocalDateTime createTimeEndWith;

    /**
     * 支付超时时间开始范围
     */
    @ApiModelProperty("支付超时时间开始范围")
    @Column(name = "payTimeoutTime")
    @SearchModel(SearchModelType.GREATER_THAN_OR_EQUAL_TO)
    private LocalDateTime payTimeoutTimeStartWith;

    /**
     * 支付超时时间结束范围
     */
    @ApiModelProperty("支付超时时间结束范围")
    @Column(name = "payTimeoutTime")
    @SearchModel(SearchModelType.LESS_THAN_OR_EQUAL_TO)
    private LocalDateTime payTimeoutTimeEndWith;

}
