package net.guerlab.smart.pay.core.searchparams;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchModel;
import net.guerlab.spring.searchparams.SearchModelType;

import javax.persistence.Column;
import java.time.LocalDateTime;

/**
 * 支付记录通知查询参数
 *
 * @author guer
 */
@Setter
@Getter
@ApiModel("支付记录通知查询参数")
public class PayLogNotifySearchParams extends AbstractSearchParams {

    /**
     * 支付记录通知ID
     */
    @ApiModelProperty("支付记录通知ID")
    private Long payLogNotifyId;

    /**
     * 支付记录ID
     */
    @ApiModelProperty("支付记录ID")
    private Long payLogId;

    /**
     * 支付订单ID
     */
    @ApiModelProperty("支付订单ID")
    private Long payOrderId;

    /**
     * 业务分组
     */
    @ApiModelProperty("业务分组")
    private String businessGroup;

    /**
     * 业务ID
     */
    @ApiModelProperty("业务ID")
    private String businessId;

    /**
     * 支付渠道
     */
    @ApiModelProperty("支付渠道")
    private String payChannel;

    /**
     * 外部订单编号
     */
    @ApiModelProperty("外部订单编号")
    private String outOrderSn;

    /**
     * 创建时间开始范围
     */
    @ApiModelProperty("创建时间开始范围")
    @Column(name = "createTime")
    @SearchModel(SearchModelType.GREATER_THAN_OR_EQUAL_TO)
    private LocalDateTime createTimeStartWith;

    /**
     * 创建时间结束范围
     */
    @ApiModelProperty("创建时间结束范围")
    @Column(name = "createTime")
    @SearchModel(SearchModelType.LESS_THAN_OR_EQUAL_TO)
    private LocalDateTime createTimeEndWith;
}
