package net.guerlab.smart.pay.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 支付记录通知
 *
 * @author guer
 */
@Data
@ApiModel("支付记录通知")
public class PayLogNotifyDTO {

    /**
     * 支付记录通知ID
     */
    @ApiModelProperty("支付记录通知ID")
    private Long payLogNotifyId;

    /**
     * 支付记录ID
     */
    @ApiModelProperty("支付记录ID")
    private Long payLogId;

    /**
     * 支付订单ID
     */
    @ApiModelProperty("支付订单ID")
    private Long payOrderId;

    /**
     * 业务分组
     */
    @ApiModelProperty("业务分组")
    private String businessGroup;

    /**
     * 业务ID
     */
    @ApiModelProperty("业务ID")
    private String businessId;

    /**
     * 支付渠道
     */
    @ApiModelProperty("支付渠道")
    private String payChannel;

    /**
     * 金额
     */
    @ApiModelProperty("金额")
    private BigDecimal amount;

    /**
     * 外部订单编号
     */
    @ApiModelProperty("外部订单编号")
    private String outOrderSn;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;
}
