package net.guerlab.smart.pay.core.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import net.guerlab.smart.pay.core.enums.PayStatus;

import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 支付记录
 *
 * @author guer
 */
@Data
@ApiModel("支付记录")
public class PayLogDTO {

    /**
     * 支付记录ID
     */
    @ApiModelProperty("支付记录ID")
    private Long payLogId;

    /**
     * 支付订单ID
     */
    @ApiModelProperty("支付订单ID")
    private Long payOrderId;

    /**
     * 订单标题
     */
    @ApiModelProperty("订单标题")
    private String orderTitle;

    /**
     * 业务分组
     */
    @ApiModelProperty("业务分组")
    private String businessGroup;

    /**
     * 业务ID
     */
    @ApiModelProperty("业务ID")
    private String businessId;

    /**
     * 支付渠道
     */
    @ApiModelProperty("支付渠道")
    private String payChannel;

    /**
     * 金额
     */
    @ApiModelProperty("金额")
    private BigDecimal amount;

    /**
     * 支付状态
     */
    @ApiModelProperty("支付状态")
    private PayStatus payStatus;

    /**
     * 创建时间
     */
    @ApiModelProperty("创建时间")
    private LocalDateTime createTime;

    /**
     * 支付超时时间
     */
    @ApiModelProperty("支付超时时间")
    private LocalDateTime payTimeoutTime;

    /**
     * 支付完成时间
     */
    @ApiModelProperty("支付完成时间")
    private LocalDateTime payedTime;

    /**
     * 支付取消时间
     */
    @ApiModelProperty("支付取消时间")
    private LocalDateTime payCancelTime;

    /**
     * 扩展信息
     */
    @ApiModelProperty("扩展信息")
    private PayLogExtends extend;
}
