/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.api.feign.factory;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.pay.api.feign.FeignPayLogApi;
import net.guerlab.smart.pay.core.domain.PayLogDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;

public class FeignPayLogApiFallbackFactory
implements FallbackFactory<FeignPayLogApi> {
    public FeignPayLogApi create(Throwable cause) {
        return new FeignPayLogApiFallback(cause);
    }

    static class FeignPayLogApiFallback
    implements FeignPayLogApi {
        private static final Logger log = LoggerFactory.getLogger(FeignPayLogApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<PayLogDTO> findOne(Long payLogId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<PayLogDTO>> findList(Map<String, Object> searchParams) {
            log.error("findOne findList", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<PayLogDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findOne findAll", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignPayLogApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

