/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.api.autoconfig;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import net.guerlab.smart.pay.api.PayOrderApi;
import net.guerlab.smart.pay.core.domain.PayOrderDTO;
import net.guerlab.smart.pay.core.exception.PayOrderInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayOrderSearchParams;
import net.guerlab.smart.pay.service.entity.PayOrder;
import net.guerlab.smart.pay.service.service.PayOrderService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.beans.BeanUtils;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class PayOrderApiLocalServiceAutoConfigure {
    @Bean
    public PayOrderApi payOrderApiLocalServiceWrapper(PayOrderService service) {
        return new PayOrderApiLocalServiceWrapper(service);
    }

    private static class PayOrderApiLocalServiceWrapper
    implements PayOrderApi {
        private final PayOrderService service;

        @Override
        public PayOrderDTO findOne(Long payOrderId) {
            return (PayOrderDTO)((PayOrder)this.service.selectByIdOptional((Serializable)payOrderId).orElseThrow(PayOrderInvalidException::new)).convert();
        }

        @Override
        public ListObject<PayOrderDTO> findList(PayOrderSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
        }

        @Override
        public List<PayOrderDTO> findAll(PayOrderSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
        }

        @Override
        public PayOrderDTO add(PayOrderDTO payOrder) {
            PayOrder order = new PayOrder();
            BeanUtils.copyProperties((Object)payOrder, (Object)order);
            this.service.insert((Object)order);
            return (PayOrderDTO)order.convert();
        }

        public PayOrderApiLocalServiceWrapper(PayOrderService service) {
            this.service = service;
        }
    }

    public static class WrapperCondition
    implements Condition {
        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.pay.service.service.PayOrderService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

