/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.pay.api.PayOrderApi;
import net.guerlab.smart.pay.api.autoconfig.PayOrderApiLocalServiceAutoConfigure;
import net.guerlab.smart.pay.api.feign.FeignPayOrderApi;
import net.guerlab.smart.pay.core.domain.PayOrderDTO;
import net.guerlab.smart.pay.core.exception.PayOrderInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayOrderSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={PayOrderApiLocalServiceAutoConfigure.class})
public class PayOrderApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={PayOrderApi.class})
    public PayOrderApi payOrderApiFeignWrapper(FeignPayOrderApi api) {
        return new PayOrderApiFeignWrapper(api);
    }

    private static class PayOrderApiFeignWrapper
    implements PayOrderApi {
        private final FeignPayOrderApi api;

        @Override
        public PayOrderDTO findOne(Long payOrderId) {
            return Optional.ofNullable((PayOrderDTO)this.api.findOne(payOrderId).getData()).orElseThrow(PayOrderInvalidException::new);
        }

        @Override
        public ListObject<PayOrderDTO> findList(PayOrderSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<PayOrderDTO> findAll(PayOrderSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        @Override
        public PayOrderDTO add(PayOrderDTO payOrder) {
            Result<PayOrderDTO> result = this.api.add(payOrder);
            if (!result.isStatus()) {
                throw new ApplicationException(result.getMessage(), result.getErrorCode());
            }
            return (PayOrderDTO)result.getData();
        }

        public PayOrderApiFeignWrapper(FeignPayOrderApi api) {
            this.api = api;
        }
    }
}

