/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.api.autoconfig;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import net.guerlab.smart.pay.api.PayLogApi;
import net.guerlab.smart.pay.core.domain.PayLogDTO;
import net.guerlab.smart.pay.core.exception.PayLogInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayLogSearchParams;
import net.guerlab.smart.pay.service.entity.PayLog;
import net.guerlab.smart.pay.service.service.PayLogService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.web.result.ListObject;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.NonNull;

@Configuration
@Conditional(value={WrapperCondition.class})
public class PayLogApiLocalServiceAutoConfigure {
    @Bean
    public PayLogApi payLogApiLocalServiceWrapper(PayLogService service) {
        return new PayLogApiLocalServiceWrapper(service);
    }

    private static class PayLogApiLocalServiceWrapper
    implements PayLogApi {
        private final PayLogService service;

        @Override
        public PayLogDTO findOne(Long payLogId) {
            return (PayLogDTO)((PayLog)this.service.selectByIdOptional((Serializable)payLogId).orElseThrow(PayLogInvalidException::new)).convert();
        }

        @Override
        public ListObject<PayLogDTO> findList(PayLogSearchParams searchParams) {
            return BeanConvertUtils.toListObject((ListObject)this.service.selectPage((AbstractSearchParams)searchParams));
        }

        @Override
        public List<PayLogDTO> findAll(PayLogSearchParams searchParams) {
            return BeanConvertUtils.toList((Collection)this.service.selectAll((AbstractSearchParams)searchParams));
        }

        public PayLogApiLocalServiceWrapper(PayLogService service) {
            this.service = service;
        }
    }

    public static class WrapperCondition
    implements Condition {
        public boolean matches(@NonNull ConditionContext context, @NonNull AnnotatedTypeMetadata metadata) {
            try {
                return WrapperCondition.class.getClassLoader().loadClass("net.guerlab.smart.pay.service.service.PayLogService") != null;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

