/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.pay.api.PayLogNotifyApi;
import net.guerlab.smart.pay.api.autoconfig.PayLogNotifyApiLocalServiceAutoConfigure;
import net.guerlab.smart.pay.api.feign.FeignPayLogNotifyApi;
import net.guerlab.smart.pay.core.domain.PayLogNotifyDTO;
import net.guerlab.smart.pay.core.exception.PayLogNotifyInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayLogNotifySearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={PayLogNotifyApiLocalServiceAutoConfigure.class})
public class PayLogNotifyApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={PayLogNotifyApi.class})
    public PayLogNotifyApi payLogNotifyApiFeignWrapper(FeignPayLogNotifyApi api) {
        return new PayLogNotifyApiFeignWrapper(api);
    }

    static class PayLogNotifyApiFeignWrapper
    implements PayLogNotifyApi {
        private final FeignPayLogNotifyApi api;

        @Override
        public PayLogNotifyDTO findOne(Long payLogNotifyId) {
            return Optional.ofNullable((PayLogNotifyDTO)this.api.findOne(payLogNotifyId).getData()).orElseThrow(PayLogNotifyInvalidException::new);
        }

        @Override
        public ListObject<PayLogNotifyDTO> findList(PayLogNotifySearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<PayLogNotifyDTO> findAll(PayLogNotifySearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public PayLogNotifyApiFeignWrapper(FeignPayLogNotifyApi api) {
            this.api = api;
        }
    }
}

