/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.api.autoconfig;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.guerlab.smart.pay.api.PayLogApi;
import net.guerlab.smart.pay.api.autoconfig.PayLogApiLocalServiceAutoConfigure;
import net.guerlab.smart.pay.api.feign.FeignPayLogApi;
import net.guerlab.smart.pay.core.domain.PayLogDTO;
import net.guerlab.smart.pay.core.exception.PayLogInvalidException;
import net.guerlab.smart.pay.core.searchparams.PayLogSearchParams;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import net.guerlab.spring.searchparams.SearchParamsUtils;
import net.guerlab.web.result.ListObject;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={PayLogApiLocalServiceAutoConfigure.class})
public class PayLogApiFeignAutoConfigure {
    @Bean
    @ConditionalOnMissingBean(value={PayLogApi.class})
    public PayLogApi payLogApiFeignWrapper(FeignPayLogApi api) {
        return new PayLogApiFeignWrapper(api);
    }

    private static class PayLogApiFeignWrapper
    implements PayLogApi {
        private final FeignPayLogApi api;

        @Override
        public PayLogDTO findOne(Long payLogId) {
            return Optional.ofNullable((PayLogDTO)this.api.findOne(payLogId).getData()).orElseThrow(PayLogInvalidException::new);
        }

        @Override
        public ListObject<PayLogDTO> findList(PayLogSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((ListObject)this.api.findList(params).getData()).orElse(ListObject.empty());
        }

        @Override
        public List<PayLogDTO> findAll(PayLogSearchParams searchParams) {
            HashMap<String, Object> params = new HashMap<String, Object>(8);
            SearchParamsUtils.handler((AbstractSearchParams)searchParams, params);
            return Optional.ofNullable((List)this.api.findAll(params).getData()).orElse(Collections.emptyList());
        }

        public PayLogApiFeignWrapper(FeignPayLogApi api) {
            this.api = api;
        }
    }
}

