/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.api.feign.factory;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.pay.api.feign.FeignPayOrderApi;
import net.guerlab.smart.pay.core.domain.PayOrderDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;

public class FeignPayOrderApiFallbackFactory
implements FallbackFactory<FeignPayOrderApi> {
    public FeignPayOrderApi create(Throwable cause) {
        return new FeignPayOrderApiFallback(cause);
    }

    static class FeignPayOrderApiFallback
    implements FeignPayOrderApi {
        private static final Logger log = LoggerFactory.getLogger(FeignPayOrderApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<PayOrderDTO> findOne(Long payOrderId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<PayOrderDTO>> findList(Map<String, Object> searchParams) {
            log.error("findOne findList", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<PayOrderDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findOne findAll", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        @Override
        public Result<PayOrderDTO> add(PayOrderDTO payOrder) {
            log.error("add fallback", this.cause);
            return new Fail("fallback");
        }

        public FeignPayOrderApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

