/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.pay.api.feign.factory;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.guerlab.smart.pay.api.feign.FeignPayLogNotifyApi;
import net.guerlab.smart.pay.core.domain.PayLogNotifyDTO;
import net.guerlab.web.result.Fail;
import net.guerlab.web.result.ListObject;
import net.guerlab.web.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.openfeign.FallbackFactory;

public class FeignPayLogNotifyApiFallbackFactory
implements FallbackFactory<FeignPayLogNotifyApi> {
    public FeignPayLogNotifyApi create(Throwable cause) {
        return new FeignPayLogNotifyApiFallback(cause);
    }

    static class FeignPayLogNotifyApiFallback
    implements FeignPayLogNotifyApi {
        private static final Logger log = LoggerFactory.getLogger(FeignPayLogNotifyApiFallback.class);
        private final Throwable cause;

        @Override
        public Result<PayLogNotifyDTO> findOne(Long payLogNotifyId) {
            log.error("findOne fallback", this.cause);
            return new Fail("fallback");
        }

        @Override
        public Result<ListObject<PayLogNotifyDTO>> findList(Map<String, Object> searchParams) {
            log.error("findOne findList", this.cause);
            return new Fail("fallback", (Object)ListObject.empty());
        }

        @Override
        public Result<List<PayLogNotifyDTO>> findAll(Map<String, Object> searchParams) {
            log.error("findOne findAll", this.cause);
            return new Fail("fallback", Collections.emptyList());
        }

        public FeignPayLogNotifyApiFallback(Throwable cause) {
            this.cause = cause;
        }
    }
}

