package net.guerlab.smart.license.web.controller.user;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.license.core.domain.LicenseDTO;
import net.guerlab.smart.license.core.exception.LicenseInvalidException;
import net.guerlab.smart.license.core.searchparams.LicenseSearchParams;
import net.guerlab.smart.license.service.entity.License;
import net.guerlab.smart.license.service.service.LicenseService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import net.guerlab.smart.platform.server.controller.BaseController;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * 授权
 *
 * @author guer
 */
@Api(tags = "授权")
@RestController("/user/license")
@RequestMapping("/user/license")
public class LicenseController extends BaseController<LicenseDTO, License, LicenseService, LicenseSearchParams, Long> {

    @Override
    protected ApplicationException nullPointException() {
        return new LicenseInvalidException();
    }

    @Override
    public void copyProperties(LicenseDTO dto, License entity, Long id) {
        super.copyProperties(dto, entity, id);
        entity.setLicenseId(id);
    }

    @ApiOperation("解析授权")
    @PostMapping("/parseLicense")
    public LicenseDTO parseLicense(@ApiParam("授权文件") @RequestParam(value = "file", required = false) MultipartFile file,
            @ApiParam("授权文件内容") @RequestParam(value = "licenseCode", required = false) String licenseCode)
            throws Exception {
        if (file != null) {
            return BeanConvertUtils.toObject(getService().parseLicense(new String(file.getBytes())));
        } else {
            return BeanConvertUtils.toObject(getService().parseLicense(licenseCode));
        }
    }
}
