package net.guerlab.smart.license.web.controller.user;

import io.swagger.annotations.Api;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.license.core.domain.LicenseGroupDTO;
import net.guerlab.smart.license.core.exception.LicenseGroupInvalidException;
import net.guerlab.smart.license.core.searchparams.LicenseGroupSearchParams;
import net.guerlab.smart.license.service.entity.LicenseGroup;
import net.guerlab.smart.license.service.service.LicenseGroupService;
import net.guerlab.smart.platform.server.controller.BaseController;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 授权分组
 *
 * @author guer
 */
@Api(tags = "授权分组")
@RestController("/user/licenseGroup")
@RequestMapping("/user/licenseGroup")
public class LicenseGroupController
        extends BaseController<LicenseGroupDTO, LicenseGroup, LicenseGroupService, LicenseGroupSearchParams, Long> {

    @Override
    protected ApplicationException nullPointException() {
        return new LicenseGroupInvalidException();
    }

    @Override
    public void copyProperties(LicenseGroupDTO dto, LicenseGroup entity, Long id) {
        super.copyProperties(dto, entity, id);
        entity.setLicenseGroupId(id);
    }
}
