package net.guerlab.smart.license.web.controller.commons;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import net.guerlab.smart.license.core.domain.LicenseDTO;
import net.guerlab.smart.license.service.service.LicenseService;
import net.guerlab.smart.platform.commons.util.BeanConvertUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

/**
 * 授权
 *
 * @author guer
 */
@Api(tags = "授权")
@RestController("/commons/license")
@RequestMapping("/commons/license")
public class LicenseController {

    private LicenseService licenseService;

    @ApiOperation("解析授权")
    @PostMapping("/parseLicense")
    public LicenseDTO parseLicense(@ApiParam("授权文件") @RequestParam(value = "file", required = false) MultipartFile file,
            @ApiParam("授权文件内容") @RequestParam(value = "licenseCode", required = false) String licenseCode)
            throws Exception {
        if (file != null) {
            return BeanConvertUtils.toObject(licenseService.parseLicense(new String(file.getBytes())));
        } else {
            return BeanConvertUtils.toObject(licenseService.parseLicense(licenseCode));
        }
    }

    @Autowired
    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }
}
