/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.license.service.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Base64;
import java.util.Date;
import java.util.Objects;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.license.core.domain.LicenseExtends;
import net.guerlab.smart.license.core.exception.LicenseBeOverdueException;
import net.guerlab.smart.license.core.exception.LicenseInvalidException;
import net.guerlab.smart.license.core.exception.LicenseParseFailException;
import net.guerlab.smart.license.service.entity.License;
import net.guerlab.smart.license.service.utils.RsaKey;
import org.apache.commons.lang3.StringUtils;

public class LicenseHelper {
    public static final String ALGORITHM = "RSA";
    public static final String EXTENDS_PREFIX = "extends:";
    public static final int EXTENDS_PREFIX_LENGTH = "extends:".length();
    public static final String LICENSE_FILE_CONTENT_SEPARATOR = ",";
    public static final int LICENSE_FILE_CONTENT_LENGTH = 6;
    private static final String KEY_LICENSE_ID = "licenseId";
    private static final String KEY_LICENSE_GROUP_ID = "licenseGroupId";
    private static final String KEY_LICENSE_GROUP_NAME = "licenseGroupName";

    private LicenseHelper() {
    }

    public static boolean match(License a, License b) {
        if (a == null || b == null) {
            return false;
        }
        if (!Objects.equals(a.getLicenseId(), b.getLicenseId())) {
            return false;
        }
        if (!Objects.equals(a.getLicenseTo(), b.getLicenseTo())) {
            return false;
        }
        if (!Objects.equals(a.getLicenseGroupId(), b.getLicenseGroupId())) {
            return false;
        }
        if (!Objects.equals(a.getLicenseStartDate(), b.getLicenseStartDate())) {
            return false;
        }
        return Objects.equals(a.getLicenseEndDate(), b.getLicenseEndDate());
    }

    public static String createLicenseCodeData(License license, RsaKey rsaKey) {
        JwtBuilder builder = Jwts.builder();
        builder.setHeaderParam("typ", (Object)"JWT");
        builder.setSubject(license.getLicenseTo());
        builder.setNotBefore(LicenseHelper.toDate(license.getLicenseStartDate()));
        builder.setExpiration(LicenseHelper.toDate(license.getLicenseEndDate()));
        builder.claim(KEY_LICENSE_ID, (Object)license.getLicenseId());
        builder.claim(KEY_LICENSE_GROUP_ID, (Object)license.getLicenseGroupId());
        builder.claim(KEY_LICENSE_GROUP_NAME, (Object)license.getLicenseGroupName());
        LicenseExtends licenseExtends = license.getLicenseExtends();
        if (licenseExtends != null && !licenseExtends.isEmpty()) {
            licenseExtends.forEach((key, value) -> builder.claim(EXTENDS_PREFIX + key, value));
        }
        try {
            PrivateKey key2 = KeyFactory.getInstance(ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(rsaKey.getPrivateKey()));
            builder.signWith(SignatureAlgorithm.RS512, (Key)key2);
            return builder.compact();
        }
        catch (Exception e) {
            throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static License parseLicense(String licenseFileCode) {
        LocalDate endDate;
        LocalDate startDate;
        Long licenseId;
        if (StringUtils.isBlank((CharSequence)licenseFileCode)) {
            throw new LicenseInvalidException();
        }
        String[] licenseFileContents = new String(Base64.getDecoder().decode(licenseFileCode)).split(LICENSE_FILE_CONTENT_SEPARATOR);
        if (licenseFileContents.length != 6) {
            throw new LicenseInvalidException();
        }
        try {
            licenseId = Long.parseLong(licenseFileContents[0]);
            startDate = LocalDate.parse(licenseFileContents[2]);
            endDate = LocalDate.parse(licenseFileContents[3]);
        }
        catch (Exception e) {
            throw new LicenseInvalidException();
        }
        String licenseTo = licenseFileContents[1];
        String licenseCode = licenseFileContents[4];
        String publicKey = licenseFileContents[5];
        if (!NumberHelper.greaterZero((Number)licenseId)) {
            throw new LicenseInvalidException();
        }
        Claims claims = LicenseHelper.parse(licenseCode, new RsaKey().setPublicKey(publicKey));
        if (!Objects.equals(claims.getSubject(), licenseTo) || !Objects.equals(claims.get(KEY_LICENSE_ID, Long.class), licenseId)) {
            throw new LicenseInvalidException();
        }
        LocalDate now = LocalDate.now();
        License license = new License();
        license.setLicenseId(licenseId);
        license.setLicenseStartDate(startDate);
        license.setLicenseEndDate(endDate);
        license.setLicenseTo(licenseTo);
        license.setLicenseCode(licenseCode);
        license.setLicenseGroupId((Long)claims.get(KEY_LICENSE_GROUP_ID, Long.class));
        license.setLicenseGroupName((String)claims.get(KEY_LICENSE_GROUP_NAME, String.class));
        license.setEffective(!now.isBefore(startDate) && !endDate.isBefore(now));
        LicenseExtends licenseExtends = new LicenseExtends();
        license.setLicenseExtends(licenseExtends);
        claims.keySet().stream().filter(key -> key.startsWith(EXTENDS_PREFIX)).forEach(key -> licenseExtends.put((Object)key.substring(EXTENDS_PREFIX_LENGTH), (Object)((String)claims.get(key, String.class))));
        return license;
    }

    private static Date toDate(LocalDate date) {
        return Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Claims parse(String licenseCode, RsaKey rsaKey) {
        try {
            PublicKey key = KeyFactory.getInstance(ALGORITHM).generatePublic(new X509EncodedKeySpec(rsaKey.getPublicKey()));
            Jws claimsJws = Jwts.parser().setSigningKey((Key)key).parseClaimsJws(licenseCode);
            return (Claims)claimsJws.getBody();
        }
        catch (ExpiredJwtException e) {
            throw new LicenseBeOverdueException();
        }
        catch (MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException e) {
            throw new LicenseParseFailException();
        }
        catch (Exception e) {
            throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

