/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.license.service.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Optional;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.license.core.domain.LicenseExtends;
import net.guerlab.smart.license.core.exception.LicenseEndDateInvalidException;
import net.guerlab.smart.license.core.exception.LicenseGroupIdInvalidException;
import net.guerlab.smart.license.core.exception.LicenseGroupInvalidException;
import net.guerlab.smart.license.core.exception.LicenseStartDateInvalidException;
import net.guerlab.smart.license.core.exception.LicenseToInvalidException;
import net.guerlab.smart.license.core.exception.LicenseToLengthErrorException;
import net.guerlab.smart.license.core.searchparams.LicenseSearchParams;
import net.guerlab.smart.license.service.entity.License;
import net.guerlab.smart.license.service.entity.LicenseGroup;
import net.guerlab.smart.license.service.handler.AfterLicenseGroupUpdateHandler;
import net.guerlab.smart.license.service.mapper.LicenseMapper;
import net.guerlab.smart.license.service.service.LicenseGroupService;
import net.guerlab.smart.license.service.service.LicenseService;
import net.guerlab.smart.license.service.utils.LicenseHelper;
import net.guerlab.smart.license.service.utils.RsaKey;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseServiceImpl
extends BaseServiceImpl<License, Long, LicenseMapper, LicenseSearchParams>
implements LicenseService,
AfterLicenseGroupUpdateHandler {
    private LicenseGroupService groupService;

    @Override
    public void setEffective(LocalDate date) {
        if (date != null) {
            ((LicenseMapper)this.getBaseMapper()).setEffective(date);
        }
    }

    @Override
    public void setInvalid(LocalDate date) {
        if (date != null) {
            ((LicenseMapper)this.getBaseMapper()).setInvalid(date);
        }
    }

    @Override
    public void revoked(Long licenseId) {
        if (NumberHelper.greaterZero((Number)licenseId)) {
            ((LicenseMapper)this.getBaseMapper()).revoked(licenseId);
        }
    }

    private void setLicenseCode(License entity, LicenseGroup licenseGroup) {
        String publicKey = licenseGroup.getPublicKey();
        String licenseCodeData = LicenseHelper.createLicenseCodeData(entity, new RsaKey().setPublicKey(publicKey).setPrivateKey(licenseGroup.getPrivateKey()));
        List<Object> params = Arrays.asList(entity.getLicenseId(), entity.getLicenseTo(), entity.getLicenseStartDate(), entity.getLicenseEndDate(), licenseCodeData, publicKey);
        String licenseCode = StringUtils.join(params, (String)",");
        entity.setLicenseCode(Base64.getEncoder().encodeToString(licenseCode.getBytes()));
        entity.setPublicKey(publicKey);
    }

    @Override
    public void afterLicenseGroupUpdateHandler(LicenseGroup licenseGroup) {
        if (licenseGroup == null) {
            return;
        }
        Long licenseGroupId = licenseGroup.getLicenseGroupId();
        String licenseGroupName = StringUtils.trimToNull((String)licenseGroup.getLicenseGroupName());
        if (!NumberHelper.greaterZero((Number)licenseGroupId) || licenseGroupName == null) {
            return;
        }
        LicenseSearchParams searchParams = new LicenseSearchParams();
        searchParams.setLicenseGroupId(licenseGroupId);
        License license = new License();
        license.setLicenseGroupName(licenseGroupName);
        ((LicenseMapper)this.getBaseMapper()).update((Object)license, (Wrapper)this.getQueryWrapper((AbstractSearchParams)searchParams));
    }

    private LicenseGroup findLicenseGroup(Long licenseGroupId) {
        if (!NumberHelper.greaterZero((Number)licenseGroupId)) {
            throw new LicenseGroupIdInvalidException();
        }
        return (LicenseGroup)((Object)this.groupService.selectByIdOptional(licenseGroupId).orElseThrow(LicenseGroupInvalidException::new));
    }

    protected void insertBefore(License entity) {
        String licenseTo = StringUtils.trimToNull((String)entity.getLicenseTo());
        Long licenseGroupId = entity.getLicenseGroupId();
        LocalDate startDate = entity.getLicenseStartDate();
        LocalDate endDate = entity.getLicenseEndDate();
        if (licenseTo == null || licenseTo.contains(",")) {
            throw new LicenseToInvalidException();
        }
        if (licenseTo.length() > 255) {
            throw new LicenseToLengthErrorException();
        }
        if (startDate == null) {
            throw new LicenseStartDateInvalidException();
        }
        if (endDate == null || startDate.isAfter(endDate)) {
            throw new LicenseEndDateInvalidException();
        }
        LicenseGroup licenseGroup = this.findLicenseGroup(licenseGroupId);
        entity.setLicenseId(this.sequence.nextId());
        entity.setLicenseTo(licenseTo);
        entity.setLicenseGroupName(licenseGroup.getLicenseGroupName());
        entity.setRemark(StringUtils.trimToEmpty((String)entity.getRemark()));
        entity.setCreateTime(LocalDateTime.now());
        entity.setLicenseStartDate(startDate);
        entity.setLicenseEndDate(endDate);
        entity.setRevoked(false);
        LocalDate now = LocalDate.now();
        entity.setEffective(!now.isBefore(startDate) && !endDate.isBefore(now));
        this.saveLicenseExtends(entity, Optional.ofNullable(entity.getLicenseExtends()).orElseGet(LicenseExtends::new));
        this.setLicenseCode(entity, licenseGroup);
    }

    protected void insertAfter(License entity) {
        this.groupService.addLicensedNumber(entity.getLicenseGroupId());
    }

    protected void updateBefore(License entity) {
        entity.setRemark(StringUtils.trimToNull((String)entity.getRemark()));
        entity.setLicenseGroupName(null);
    }

    private void saveLicenseExtends(License entity, LicenseExtends licenseExtends) {
        LicenseExtends saveLicenseExtends = new LicenseExtends();
        licenseExtends.forEach((key, value) -> {
            String k = StringUtils.trimToNull((String)key);
            String v = StringUtils.trimToNull((String)value);
            if (k != null && v != null) {
                saveLicenseExtends.put((Object)k, (Object)v);
            }
        });
        entity.setLicenseExtends(saveLicenseExtends);
    }

    @Autowired
    public void setGroupService(LicenseGroupService groupService) {
        this.groupService = groupService;
    }
}

