package net.guerlab.smart.license.service.service;

import net.guerlab.smart.license.core.searchparams.LicenseSearchParams;
import net.guerlab.smart.license.service.entity.License;
import net.guerlab.smart.platform.server.service.BaseService;

import java.time.LocalDate;

/**
 * 授权服务
 *
 * @author guer
 */
public interface LicenseService extends BaseService<License, Long, LicenseSearchParams> {

    /**
     * 授权目标最大长度
     */
    int LICENSE_TO_MAX_LENGTH = 255;

    /**
     * 设置有效性
     *
     * @param date
     *         日期
     */
    void setEffective(LocalDate date);

    /**
     * 设置无效性
     *
     * @param date
     *         日期
     */
    void setInvalid(LocalDate date);

    /**
     * 吊销
     *
     * @param licenseId
     *         授权ID
     */
    void revoked(Long licenseId);

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<License> getEntityClass() {
        return License.class;
    }
}
