package net.guerlab.smart.license.service.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.license.core.domain.LicenseGroupDTO;
import net.guerlab.smart.platform.commons.entity.BaseEntity;
import net.guerlab.spring.commons.dto.DefaultConvert;

import java.time.LocalDateTime;

/**
 * 授权组
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("license_group")
public class LicenseGroup extends BaseEntity implements DefaultConvert<LicenseGroupDTO> {

    /**
     * 授权组ID
     */
    @TableId
    private Long licenseGroupId;

    /**
     * 授权组名称
     */
    @TableField(value = "licenseGroupName")
    private String licenseGroupName;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 创建时间
     */
    @TableField(value = "createTime", updateStrategy = FieldStrategy.NEVER)
    private LocalDateTime createTime;

    /**
     * 已授权数量
     */
    @TableField(value = "licensedNumber")
    private Long licensedNumber;

    /**
     * 公钥文件内容
     */
    @TableField(value = "publicKey", updateStrategy = FieldStrategy.NEVER)
    private String publicKey;

    /**
     * 私钥文件内容
     */
    @TableField(value = "privateKey", updateStrategy = FieldStrategy.NEVER)
    private String privateKey;

    /**
     * 允许删除标志
     */
    @TableField(value = "allowDelete", updateStrategy = FieldStrategy.NEVER)
    private Boolean allowDelete;
}
