package net.guerlab.smart.license.service.entity;

import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.license.core.domain.LicenseDTO;
import net.guerlab.smart.license.core.domain.LicenseExtends;
import net.guerlab.smart.platform.commons.entity.BaseEntity;
import net.guerlab.spring.commons.dto.DefaultConvert;

import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 授权
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@TableName("license_license")
public class License extends BaseEntity implements DefaultConvert<LicenseDTO> {

    /**
     * 授权ID
     */
    @TableId
    private Long licenseId;

    /**
     * 授权目标
     */
    @TableField(value = "licenseTo", updateStrategy = FieldStrategy.NEVER)
    private String licenseTo;

    /**
     * 授权组ID
     */
    @TableField(value = "licenseGroupId", updateStrategy = FieldStrategy.NEVER)
    private Long licenseGroupId;

    /**
     * 授权组名称
     */
    @TableField(value = "licenseGroupName")
    private String licenseGroupName;

    /**
     * 备注
     */
    @TableField(value = "remark")
    private String remark;

    /**
     * 创建时间
     */
    @TableField(value = "createTime", updateStrategy = FieldStrategy.NEVER)
    private LocalDateTime createTime;

    /**
     * 授权起始日期
     */
    @TableField(value = "licenseStartDate", updateStrategy = FieldStrategy.NEVER)
    private LocalDate licenseStartDate;

    /**
     * 授权结束日期
     */
    @TableField(value = "licenseEndDate", updateStrategy = FieldStrategy.NEVER)
    private LocalDate licenseEndDate;

    /**
     * 授权文件内容
     */
    @TableField(value = "licenseCode", updateStrategy = FieldStrategy.NEVER)
    private String licenseCode;

    /**
     * 公钥文件内容
     */
    @TableField(value = "publicKey", updateStrategy = FieldStrategy.NEVER)
    private String publicKey;

    /**
     * 扩展信息表
     */
    @TableField(value = "licenseExtends", updateStrategy = FieldStrategy.NEVER)
    private LicenseExtends licenseExtends;

    /**
     * 吊销标志
     */
    @TableField(value = "revoked", updateStrategy = FieldStrategy.NEVER)
    private Boolean revoked;

    /**
     * 生效中标志
     */
    @TableField(value = "effective", updateStrategy = FieldStrategy.NEVER)
    private Boolean effective;
}
