package net.guerlab.smart.license.service.crons;

import net.guerlab.smart.license.service.service.LicenseService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.time.LocalDate;

/**
 * 授权计划任务
 *
 * @author guer
 */
@Component
public class LicenseCron {

    private LicenseService service;

    /**
     * 设置有效性
     */
    @Scheduled(cron = "0 * * * * ? ")
    public void setEffective() {
        service.setEffective(LocalDate.now());
    }

    /**
     * 设置无效性
     */
    @Scheduled(cron = "0 * * * * ? ")
    public void setInvalid() {
        service.setInvalid(LocalDate.now());
    }

    @Autowired
    public void setService(LicenseService service) {
        this.service = service;
    }
}
