/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.license.service.service.impl;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.time.LocalDateTime;
import java.util.Base64;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.license.core.exception.LicenseGroupCannotDeleteException;
import net.guerlab.smart.license.core.exception.LicenseGroupIdInvalidException;
import net.guerlab.smart.license.core.exception.LicenseGroupNameInvalidException;
import net.guerlab.smart.license.core.exception.LicenseGroupNameLengthErrorException;
import net.guerlab.smart.license.core.searchparams.LicenseSearchParams;
import net.guerlab.smart.license.service.entity.LicenseGroup;
import net.guerlab.smart.license.service.mapper.LicenseGroupMapper;
import net.guerlab.smart.license.service.service.AfterLicenseGroupUpdateHandler;
import net.guerlab.smart.license.service.service.LicenseGroupService;
import net.guerlab.smart.license.service.service.LicenseService;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.spring.commons.util.SpringApplicationContextUtil;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseGroupServiceImpl
extends BaseServiceImpl<LicenseGroup, Long, LicenseGroupMapper>
implements LicenseGroupService {
    private LicenseService licenseService;

    @Override
    public void addLicensedNumber(Long licenseGroupId) {
        if (!NumberHelper.greaterZero((Number)licenseGroupId)) {
            throw new LicenseGroupIdInvalidException();
        }
        ((LicenseGroupMapper)this.mapper).addLicensedNumber(licenseGroupId);
    }

    protected void insertBefore(LicenseGroup entity) {
        String licenseGroupName = StringUtils.trimToNull((String)entity.getLicenseGroupName());
        if (licenseGroupName == null) {
            throw new LicenseGroupNameInvalidException();
        }
        if (licenseGroupName.length() > 255) {
            throw new LicenseGroupNameLengthErrorException();
        }
        entity.setLicenseGroupId(this.sequence.nextId());
        entity.setLicenseGroupName(licenseGroupName);
        entity.setRemark(StringUtils.trimToEmpty((String)entity.getRemark()));
        entity.setCreateTime(LocalDateTime.now());
        entity.setLicensedNumber(0L);
        entity.setAllowDelete(true);
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            keyPairGenerator.initialize(2048);
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            entity.setPublicKey(Base64.getEncoder().encodeToString(keyPair.getPublic().getEncoded()));
            entity.setPrivateKey(Base64.getEncoder().encodeToString(keyPair.getPrivate().getEncoded()));
        }
        catch (Exception e) {
            throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void updateBefore(LicenseGroup entity) {
        String licenseGroupName = StringUtils.trimToNull((String)entity.getLicenseGroupName());
        if (licenseGroupName != null && licenseGroupName.length() > 255) {
            throw new LicenseGroupNameLengthErrorException();
        }
        entity.setLicenseGroupName(licenseGroupName);
        entity.setLicensedNumber(null);
    }

    protected void updateAfter(LicenseGroup entity) {
        SpringApplicationContextUtil.getContext().getBeansOfType(AfterLicenseGroupUpdateHandler.class).values().forEach(handler -> handler.afterLicenseGroupUpdateHandler(entity));
    }

    protected void deleteBefore(LicenseGroup entity, Boolean force) {
        this.deleteByIdBefore(entity.getLicenseGroupId(), force);
    }

    protected void deleteByIdBefore(Long id, Boolean force) {
        LicenseSearchParams searchParams = new LicenseSearchParams();
        searchParams.setLicenseGroupId(id);
        if (this.licenseService.selectCount((AbstractSearchParams)searchParams) > 0) {
            throw new LicenseGroupCannotDeleteException();
        }
    }

    @Autowired
    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }
}

