package net.guerlab.spring.mybatis.typehandlers;

import com.fasterxml.jackson.databind.ObjectMapper;
import net.guerlab.smart.license.core.domain.LicenseExtends;
import net.guerlab.spring.commons.util.SpringApplicationContextUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * 扩展信息表类型处理
 *
 * @author guer
 */
@SuppressWarnings("WeakerAccess")
public class LicenseExtendsTypeHandler extends BaseTypeHandler<LicenseExtends> {

    @Override
    public void setNonNullParameter(PreparedStatement ps, int i, LicenseExtends parameter, JdbcType jdbcType)
            throws SQLException {
        ps.setString(i, toJson(parameter));
    }

    @Override
    public LicenseExtends getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return toObject(rs.getString(columnName));
    }

    @Override
    public LicenseExtends getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return toObject(rs.getString(columnIndex));
    }

    @Override
    public LicenseExtends getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return toObject(cs.getString(columnIndex));
    }

    private ObjectMapper objectMapper() {
        return SpringApplicationContextUtil.getContext().getBean(ObjectMapper.class);
    }

    private String toJson(LicenseExtends object) {
        try {
            return objectMapper().writeValueAsString(object);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private LicenseExtends toObject(String content) {
        if (StringUtils.isBlank(content)) {
            return null;
        }

        try {
            return objectMapper().readValue(content, LicenseExtends.class);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}
