package net.guerlab.smart.license.service.utils;

import java.util.Base64;

/**
 * rasKey
 *
 * @author guer
 */
public class RsaKey {

    /**
     * 公钥内容
     */
    private byte[] publicKey;

    /**
     * 私钥内容
     */
    private byte[] privateKey;

    /**
     * 获取公钥
     *
     * @return 公钥
     */
    public byte[] getPublicKey() {
        return publicKey;
    }

    /**
     * 设置公钥
     *
     * @param publicKey
     *         公钥
     * @return rasKey
     */
    public RsaKey setPublicKey(String publicKey) {
        this.publicKey = Base64.getDecoder().decode(publicKey);
        return this;
    }

    /**
     * 获取私钥
     *
     * @return 私钥
     */
    public byte[] getPrivateKey() {
        return privateKey;
    }

    /**
     * 设置私钥
     *
     * @param privateKey
     *         私钥
     * @return rasKey
     */
    public RsaKey setPrivateKey(String privateKey) {
        this.privateKey = Base64.getDecoder().decode(privateKey);
        return this;
    }
}
