package net.guerlab.smart.license.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.license.core.domain.LicenseDTO;
import net.guerlab.smart.license.core.domain.LicenseExtends;
import net.guerlab.smart.platform.commons.entity.BaseEntity;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 授权
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Table(name = "license_license")
public class License extends BaseEntity implements DefaultConvertDTO<LicenseDTO> {

    /**
     * 授权ID
     */
    @Id
    private Long licenseId;

    /**
     * 授权目标
     */
    @Column(name = "licenseTo", nullable = false, updatable = false)
    private String licenseTo;

    /**
     * 授权组ID
     */
    @Column(name = "licenseGroupId", nullable = false, updatable = false)
    private Long licenseGroupId;

    /**
     * 授权组名称
     */
    @Column(name = "licenseGroupName", nullable = false)
    private String licenseGroupName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "createTime", nullable = false, updatable = false)
    private LocalDateTime createTime;

    /**
     * 授权起始日期
     */
    @Column(name = "licenseStartDate", nullable = false, updatable = false)
    private LocalDate licenseStartDate;

    /**
     * 授权结束日期
     */
    @Column(name = "licenseEndDate", nullable = false, updatable = false)
    private LocalDate licenseEndDate;

    /**
     * 授权文件内容
     */
    @Column(name = "licenseCode", nullable = false, updatable = false)
    private String licenseCode;

    /**
     * 公钥文件内容
     */
    @Column(name = "publicKey", nullable = false, updatable = false)
    private String publicKey;

    /**
     * 扩展信息表
     */
    @Column(name = "licenseExtends", nullable = false, updatable = false)
    private LicenseExtends licenseExtends;

    /**
     * 吊销标志
     */
    @Column(name = "revoked", nullable = false, updatable = false)
    private Boolean revoked;

    /**
     * 生效中标志
     */
    @Column(name = "effective", nullable = false, updatable = false)
    private Boolean effective;
}
