/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.license.service.utils;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.UnsupportedJwtException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.license.core.exception.LicenseBeOverdueException;
import net.guerlab.smart.license.core.exception.LicenseParseFailException;
import net.guerlab.smart.license.service.entity.License;
import net.guerlab.smart.license.service.utils.RsaKey;

public class LicenseCodeHelper {
    public static final String ALGORITHM = "RSA";

    private LicenseCodeHelper() {
    }

    public static String createLicenseCodeData(License license, RsaKey rsaKey) {
        JwtBuilder builder = Jwts.builder();
        builder.setHeaderParam("typ", (Object)"JWT");
        builder.setSubject(license.getLicenseTo());
        builder.setNotBefore(LicenseCodeHelper.toDate(license.getLicenseStartDate()));
        builder.setExpiration(LicenseCodeHelper.toDate(license.getLicenseEndDate()));
        builder.claim("licenseId", (Object)license.getLicenseId());
        try {
            PrivateKey key = KeyFactory.getInstance(ALGORITHM).generatePrivate(new PKCS8EncodedKeySpec(rsaKey.getPrivateKey()));
            builder.signWith(SignatureAlgorithm.RS512, (Key)key);
            return builder.compact();
        }
        catch (Exception e) {
            throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private static Date toDate(LocalDate date) {
        return Date.from(date.atStartOfDay(ZoneId.systemDefault()).toInstant());
    }

    public static Claims parse(String licenseCode, RsaKey rsaKey) {
        try {
            PublicKey key = KeyFactory.getInstance(ALGORITHM).generatePublic(new X509EncodedKeySpec(rsaKey.getPublicKey()));
            Jws claimsJws = Jwts.parser().setSigningKey((Key)key).parseClaimsJws(licenseCode);
            return (Claims)claimsJws.getBody();
        }
        catch (ExpiredJwtException e) {
            throw new LicenseBeOverdueException();
        }
        catch (MalformedJwtException | SignatureException | UnsupportedJwtException | IllegalArgumentException e) {
            throw new LicenseParseFailException();
        }
        catch (Exception e) {
            throw new ApplicationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

