/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.license.service.service.impl;

import io.jsonwebtoken.Claims;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Base64;
import java.util.Objects;
import net.guerlab.commons.number.NumberHelper;
import net.guerlab.smart.license.core.exception.LicenseEndDateInvalidException;
import net.guerlab.smart.license.core.exception.LicenseGroupIdInvalidException;
import net.guerlab.smart.license.core.exception.LicenseGroupInvalidException;
import net.guerlab.smart.license.core.exception.LicenseInvalidException;
import net.guerlab.smart.license.core.exception.LicenseStartDateInvalidException;
import net.guerlab.smart.license.core.exception.LicenseToInvalidException;
import net.guerlab.smart.license.core.searchparams.LicenseSearchParams;
import net.guerlab.smart.license.service.entity.License;
import net.guerlab.smart.license.service.entity.LicenseGroup;
import net.guerlab.smart.license.service.mapper.LicenseMapper;
import net.guerlab.smart.license.service.service.AfterLicenseGroupUpdateHandler;
import net.guerlab.smart.license.service.service.LicenseGroupService;
import net.guerlab.smart.license.service.service.LicenseService;
import net.guerlab.smart.license.service.utils.LicenseCodeHelper;
import net.guerlab.smart.license.service.utils.RsaKey;
import net.guerlab.smart.platform.server.service.BaseServiceImpl;
import net.guerlab.spring.searchparams.AbstractSearchParams;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseServiceImpl
extends BaseServiceImpl<License, Long, LicenseMapper>
implements LicenseService,
AfterLicenseGroupUpdateHandler {
    private static final String LICENSE_FILE_CONTENT_SEPARATOR = ",";
    private static final int LICENSE_FILE_CONTENT_LENGTH = 6;
    private LicenseGroupService groupService;

    @Override
    public License parseLicense(String licenseFileCode) {
        LocalDate endDate;
        LocalDate startDate;
        Long licenseId;
        if (StringUtils.isBlank((CharSequence)licenseFileCode)) {
            throw new LicenseInvalidException();
        }
        String[] licenseFileContents = new String(Base64.getDecoder().decode(licenseFileCode)).split(LICENSE_FILE_CONTENT_SEPARATOR);
        if (licenseFileContents.length != 6) {
            throw new LicenseInvalidException();
        }
        try {
            licenseId = Long.parseLong(licenseFileContents[0]);
            startDate = LocalDate.parse(licenseFileContents[2]);
            endDate = LocalDate.parse(licenseFileContents[3]);
        }
        catch (Exception e) {
            throw new LicenseInvalidException();
        }
        String licenseTo = licenseFileContents[1];
        String licenseCode = licenseFileContents[4];
        String publicKey = licenseFileContents[5];
        if (!NumberHelper.greaterZero((Number)licenseId)) {
            throw new LicenseInvalidException();
        }
        License license = (License)((Object)this.selectByIdOptional(licenseId).orElseThrow(LicenseInvalidException::new));
        if (!(Objects.equals(license.getLicenseTo(), licenseTo) && Objects.equals(license.getLicenseStartDate(), startDate) && Objects.equals(license.getLicenseEndDate(), endDate) && Objects.equals(license.getPublicKey(), publicKey))) {
            throw new LicenseInvalidException();
        }
        Claims claims = LicenseCodeHelper.parse(licenseCode, new RsaKey().setPublicKey(publicKey));
        if (!Objects.equals(claims.getSubject(), licenseTo)) {
            throw new LicenseInvalidException();
        }
        return license;
    }

    private void setLicenseCode(License entity, LicenseGroup licenseGroup) {
        String licenseCode = entity.getLicenseId() + LICENSE_FILE_CONTENT_SEPARATOR + entity.getLicenseTo() + LICENSE_FILE_CONTENT_SEPARATOR + entity.getLicenseStartDate() + LICENSE_FILE_CONTENT_SEPARATOR + entity.getLicenseEndDate() + LICENSE_FILE_CONTENT_SEPARATOR + LicenseCodeHelper.createLicenseCodeData(entity, new RsaKey().setPublicKey(licenseGroup.getPublicKey()).setPrivateKey(licenseGroup.getPrivateKey())) + LICENSE_FILE_CONTENT_SEPARATOR + licenseGroup.getPublicKey();
        entity.setLicenseCode(Base64.getEncoder().encodeToString(licenseCode.getBytes()));
        entity.setPublicKey(licenseGroup.getPublicKey());
    }

    @Override
    public void afterLicenseGroupUpdateHandler(LicenseGroup licenseGroup) {
        if (licenseGroup == null || !NumberHelper.greaterZero((Number)licenseGroup.getLicenseGroupId()) || StringUtils.isBlank((CharSequence)licenseGroup.getLicenseGroupName())) {
            return;
        }
        LicenseSearchParams searchParams = new LicenseSearchParams();
        searchParams.setLicenseGroupId(licenseGroup.getLicenseGroupId());
        License license = new License();
        license.setLicenseGroupName(licenseGroup.getLicenseGroupName().trim());
        ((LicenseMapper)this.mapper).updateByExampleSelective((Object)license, this.getExample((AbstractSearchParams)searchParams));
    }

    private LicenseGroup findLicenseGroup(Long licenseGroupId) {
        if (!NumberHelper.greaterZero((Number)licenseGroupId)) {
            throw new LicenseGroupIdInvalidException();
        }
        return (LicenseGroup)((Object)this.groupService.selectByIdOptional(licenseGroupId).orElseThrow(LicenseGroupInvalidException::new));
    }

    protected void insertBefore(License entity) {
        String licenseTo = StringUtils.stripToNull((String)entity.getLicenseTo());
        Long licenseGroupId = entity.getLicenseGroupId();
        LocalDate licenseStartDate = entity.getLicenseStartDate();
        LocalDate licenseEndDate = entity.getLicenseEndDate();
        if (licenseTo == null || licenseTo.contains(LICENSE_FILE_CONTENT_SEPARATOR)) {
            throw new LicenseToInvalidException();
        }
        if (licenseStartDate == null) {
            throw new LicenseStartDateInvalidException();
        }
        if (licenseEndDate == null || licenseStartDate.isAfter(licenseEndDate)) {
            throw new LicenseEndDateInvalidException();
        }
        LicenseGroup licenseGroup = this.findLicenseGroup(licenseGroupId);
        entity.setLicenseId(this.sequence.nextId());
        entity.setLicenseTo(licenseTo);
        entity.setLicenseGroupName(licenseGroup.getLicenseGroupName());
        entity.setRemark(StringUtils.trimToEmpty((String)entity.getRemark()));
        entity.setCreateTime(LocalDateTime.now());
        entity.setLicenseStartDate(licenseStartDate);
        entity.setLicenseEndDate(licenseEndDate);
        this.setLicenseCode(entity, licenseGroup);
    }

    protected void insertAfter(License entity) {
        this.groupService.addLicensedNumber(entity.getLicenseGroupId());
    }

    protected void updateBefore(License entity) {
        Long licenseGroupId = entity.getLicenseGroupId();
        LocalDate licenseStartDate = entity.getLicenseStartDate();
        LocalDate licenseEndDate = entity.getLicenseEndDate();
        if (licenseStartDate != null && licenseEndDate != null && NumberHelper.greaterZero((Number)licenseGroupId)) {
            if (licenseStartDate.isAfter(licenseEndDate)) {
                throw new LicenseEndDateInvalidException();
            }
            LicenseGroup licenseGroup = this.findLicenseGroup(licenseGroupId);
            this.setLicenseCode(entity, licenseGroup);
        } else {
            entity.setLicenseStartDate(null);
            entity.setLicenseEndDate(null);
            entity.setLicenseCode(null);
            entity.setPublicKey(null);
        }
    }

    @Autowired
    public void setGroupService(LicenseGroupService groupService) {
        this.groupService = groupService;
    }
}

