package net.guerlab.smart.license.service.service;

import net.guerlab.smart.license.service.entity.License;
import net.guerlab.smart.platform.server.service.BaseService;

/**
 * 授权服务
 *
 * @author guer
 */
public interface LicenseService extends BaseService<License, Long> {

    /**
     * 解析授权文件内容
     *
     * @param licenseFileCode
     *         授权文件内容
     * @return 授权信息
     */
    License parseLicense(String licenseFileCode);

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<License> getEntityClass() {
        return License.class;
    }
}
