package net.guerlab.smart.license.service.service;

import net.guerlab.smart.license.service.entity.LicenseGroup;
import net.guerlab.smart.platform.server.service.BaseService;

/**
 * 授权组服务
 *
 * @author guer
 */
public interface LicenseGroupService extends BaseService<LicenseGroup, Long> {

    /**
     * 添加已授权数量
     *
     * @param licenseGroupId
     *         授权组ID
     */
    void addLicensedNumber(Long licenseGroupId);

    /**
     * 减少已授权数量
     *
     * @param licenseGroupId
     *         授权组ID
     */
    void reduceLicensedNumber(Long licenseGroupId);

    /**
     * 获取实体类型
     *
     * @return 实体类型
     */
    @Override
    default Class<LicenseGroup> getEntityClass() {
        return LicenseGroup.class;
    }
}
