package net.guerlab.smart.license.service.entity;

import lombok.Data;
import lombok.EqualsAndHashCode;
import net.guerlab.smart.license.core.domain.LicenseGroupDTO;
import net.guerlab.smart.platform.commons.entity.BaseEntity;
import net.guerlab.spring.commons.dto.DefaultConvertDTO;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;
import java.time.LocalDateTime;

/**
 * 授权组
 *
 * @author guer
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Table(name = "license_group")
public class LicenseGroup extends BaseEntity implements DefaultConvertDTO<LicenseGroupDTO> {

    /**
     * 授权组ID
     */
    @Id
    private Long licenseGroupId;

    /**
     * 授权组名称
     */
    @Column(name = "licenseGroupName", nullable = false)
    private String licenseGroupName;

    /**
     * 备注
     */
    private String remark;

    /**
     * 创建时间
     */
    @Column(name = "createTime", nullable = false, updatable = false)
    private LocalDateTime createTime;

    /**
     * 已授权数量
     */
    @Column(name = "licensedNumber", nullable = false)
    private Long licensedNumber;

    /**
     * 公钥文件内容
     */
    @Column(name = "publicKey", nullable = false, updatable = false)
    private String publicKey;

    /**
     * 私钥文件内容
     */
    @Column(name = "privateKey", nullable = false, updatable = false)
    private String privateKey;
}
