/*
 * Decompiled with CFR 0.152.
 */
package net.guerlab.smart.dingtalk.web.controller.user;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import net.guerlab.commons.exception.ApplicationException;
import net.guerlab.smart.dingtalk.core.domain.DingTalkAppDTO;
import net.guerlab.smart.dingtalk.core.enums.DingTalkAppType;
import net.guerlab.smart.dingtalk.core.exception.DingTalkAppInvalidException;
import net.guerlab.smart.dingtalk.core.searchparams.DingTalkAppSearchParams;
import net.guerlab.smart.dingtalk.service.entity.DingTalkApp;
import net.guerlab.smart.dingtalk.service.service.DingTalkAppService;
import net.guerlab.smart.dingtalk.service.service.DingTalkClientManagerService;
import net.guerlab.smart.platform.server.controller.BaseController;
import net.guerlab.smart.user.api.OperationLogApi;
import net.guerlab.smart.user.auth.UserContextHandler;
import net.guerlab.spring.commons.dto.Convert;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u9489\u9489\u5e94\u7528")
@RestController(value="/user/dingTalkApp")
@RequestMapping(value={"/user/dingTalkApp"})
public class DingTalkAppController
extends BaseController<DingTalkAppDTO, DingTalkApp, DingTalkAppService, DingTalkAppSearchParams, String> {
    private DingTalkClientManagerService managerService;
    private OperationLogApi operationLogApi;

    protected ApplicationException nullPointException() {
        return new DingTalkAppInvalidException();
    }

    public void copyProperties(DingTalkAppDTO dto, DingTalkApp entity, String id) {
        DingTalkAppType appType = entity.getAppType();
        super.copyProperties((Object)dto, (Convert)entity, (Serializable)((Object)id));
        if (id == null) {
            return;
        }
        entity.setAppKey(id);
        entity.setAppType(appType);
    }

    @Operation(description="\u79fb\u9664Token\u7f13\u5b58", security={@SecurityRequirement(name="Authorization")})
    @PostMapping(value={"/{appKey}/removeTokenCache"})
    public void removeTokenCache(@Parameter(description="appKey", required=true) @PathVariable String appKey) {
        DingTalkApp app = (DingTalkApp)this.findOne0((Serializable)((Object)appKey));
        this.managerService.getClient(appKey).getDingTalkConfigStorage().expireAccessToken();
        this.operationLogApi.add("\u79fb\u9664Token\u7f13\u5b58", UserContextHandler.getUserId(), new Object[]{app});
    }

    public void afterSave(DingTalkApp entity, DingTalkAppDTO dto) {
        this.operationLogApi.add("\u6dfb\u52a0\u9489\u9489\u5e94\u7528", UserContextHandler.getUserId(), new Object[]{entity});
    }

    public void afterUpdate(DingTalkApp entity, DingTalkAppDTO dto) {
        this.operationLogApi.add("\u7f16\u8f91\u9489\u9489\u5e94\u7528", UserContextHandler.getUserId(), new Object[]{entity});
    }

    public void afterDelete(DingTalkApp entity) {
        this.operationLogApi.add("\u5220\u9664\u9489\u9489\u5e94\u7528", UserContextHandler.getUserId(), new Object[]{entity.getAppKey()});
    }

    @Autowired
    public void setManagerService(DingTalkClientManagerService managerService) {
        this.managerService = managerService;
    }

    @Autowired
    public void setOperationLogApi(OperationLogApi operationLogApi) {
        this.operationLogApi = operationLogApi;
    }
}

